# Stepper library

This library allows you to control unipolar or bipolar stepper motors. To use it you will need a stepper motor, and the appropriate hardware to control it.

To use this library:

```
#include <Stepper.h>
```

## Circuits

* [Unipolar steppers](https://docs.arduino.cc/learn/electronics/stepper-motors#unipolar-stepper-circuit-and-schematic).
* [Bipolar steppers](https://docs.arduino.cc/learn/electronics/stepper-motors#bipolar-stepper-circuit-and-schematic).

## Examples

* [Motor knob](https://docs.arduino.cc/learn/electronics/stepper-motors#motorknob): Control a highly accurate stepper motor using a potentiometer.
* [Stepper one revolution](https://docs.arduino.cc/learn/electronics/stepper-motors#stepperonerevolution): Turn the shaft one revolution clockwise and one counterclockwise.
* [Stepper one step at a time](https://docs.arduino.cc/learn/electronics/stepper-motors#stepperonestepatatime): Turn the shaft step by step to check the proper wiring of the motor.
* [Stepper speed control](https://docs.arduino.cc/learn/electronics/stepper-motors#stepperspeedcontrol): Control the stepping speed with a potentiometer.